/* ****************************************************************************
 * Copyright: 2017-2025 RAYLASE GmbH
 * This source code is the proprietary confidential property of RAYLASE GmbH.
 * Reproduction, publication, or any form of distribution to
 * any party other than the licensee is strictly prohibited.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#pragma once

namespace Private
{
	template<typename T> struct ScopeExitHandler
	{
		T Lambda;
		inline ~ScopeExitHandler() { Lambda(); }
	};
	struct ScopeExitHandlerHelp
	{
		template<typename T> inline constexpr ScopeExitHandler<T> operator+(T&& t) const noexcept { return ScopeExitHandler<T>(static_cast<T&&>(t)); }
	};
} // namespace Private
#define COMBINE(X, Y) X##Y
#define COMBINE_EXPANDED(X, Y) COMBINE(X, Y)

// Helper macro to defer an execution to the end of the scope at all circumstances (exception, continue, etc).
// Example:
//    FILE* f = fopen(...);
//    DEFER { fclose (f); }
//    <do things with the file>
#define DEFER const auto COMBINE_EXPANDED(DEFER_local_, __LINE__) = ::Private::ScopeExitHandlerHelp() + [&]() noexcept